<x-filament-panels::page>
    <style>
        /* Global layout sync with Filament */
        body,
        .fi-body,
        .fi-layout,
        .fi-main {
            transition: background-color 0.4s ease, color 0.3s ease;
        }

        /* Light mode defaults */
        :root {
            --page-bg: #f8fafc;
            --page-text: #1e293b;
            --card-bg: #ffffff;
            --card-text: #1e293b;
            --card-border: rgba(0, 0, 0, 0.08);
            --accent: #2563eb;
            --accent-hover: #1d4ed8;
        }

        /* Dark mode (Filament applies .dark to <html>) */
        html.dark,
        body.dark {
            --page-bg: #0f172a;
            --page-text: #f8fafc;
            --card-bg: #1e293b;
            --card-text: #f8fafc;
            --card-border: rgba(255, 255, 255, 0.1);
            --accent: #3b82f6;
            --accent-hover: #60a5fa;
        }

        /* Apply background + text globally */
        body,
        .fi-body,
        .fi-layout,
        .fi-main {
            background-color: var(--page-bg) !important;
            color: var(--page-text) !important;
        }

        /* Wrapper for centering */
        .card-wrapper {
            display: flex;
            justify-content: center;
            align-items: flex-start;
            padding: 40px 16px;
        }

        /* Main card */
        .custom-card {
            background-color: var(--card-bg);
            color: var(--card-text);
            border: 1px solid var(--card-border);
            border-radius: 16px;
            max-width: 520px;
            width: 100%;
            padding: 28px 24px;
            box-shadow: 0 8px 24px rgba(0, 0, 0, 0.08);
            transition: all 0.3s ease-in-out;
        }

        /* Title + subtitle */
        .card-title {
            font-size: 1.3rem;
            font-weight: 600;
            margin-bottom: 8px;
        }

        .card-sub {
            color: #64748b;
            font-size: 0.95rem;
            margin-bottom: 20px;
        }

        html.dark .card-sub {
            color: #94a3b8;
        }

        /* Inputs */
        .custom-card input[type="text"],
        .custom-card input[type="password"],
        .custom-card input[type="email"],
        .custom-card select,
        .custom-card textarea {
            width: 100%;
            border-radius: 10px;
            border: 1px solid var(--card-border);
            background-color: transparent;
            color: inherit;
            font-size: 1rem;
            padding: 10px 12px;
            outline: none;
            transition: border-color 0.2s ease, box-shadow 0.2s ease;
        }

        .custom-card input:focus {
            border-color: var(--accent);
            box-shadow: 0 0 0 2px var(--accent-hover);
        }

        /* Buttons */
        .custom-card .btn {
            background-color: var(--accent);
            color: #fff;
            font-weight: 600;
            border: none;
            border-radius: 10px;
            padding: 10px 18px;
            cursor: pointer;
            font-size: 0.95rem;
            transition: all 0.2s ease;
        }

        .custom-card .btn:hover {
            background-color: var(--accent-hover);
            transform: translateY(-2px);
        }

        .card-actions {
            text-align: right;
            margin-top: 16px;
        }

        [data-livewire-notifications-container] {
            position: fixed !important;
            top: 50% !important;
            left: 50% !important;
            right: auto !important;
            bottom: auto !important;
            transform: translate(-50%, -50%) !important;
            z-index: 9999;
        }

        /* Center each notification toast */
        [data-livewire-notifications-container] > div {
            margin: 0 auto !important;
            width: auto !important;
            min-width: 300px;
        }
    </style>

    <div class="card-wrapper">
        <div class="custom-card">
            <div class="card-title">Change Password</div>
            <div class="card-sub">Enter your current and new password below.</div>

            {{ $this->form }}

            <div class="card-actions">
                <x-filament::button class="btn" wire:click="submit">
                    Change Password
                </x-filament::button>
            </div>
        </div>
    </div>
</x-filament-panels::page>
