<?php

namespace App\Providers;

use Filament\Panel;
use Filament\PanelProvider;
use Filament\Facades\Filament;
use Filament\Pages;
use Filament\Widgets;

class AdminPanelProvider extends PanelProvider
{
    public function panel(Panel $panel): Panel
    {
        return $panel
            ->default() // ✅ This makes it the default Filament panel
            ->id('admin')
            ->path('admin')
            ->login(\App\Filament\Pages\Auth\UsernameLogin::class)
            ->middleware(['web'])
            ->discoverResources(in: app_path('Filament/Resources'), for: 'App\\Filament\\Resources')
            ->discoverPages(in: app_path('Filament/Pages'), for: 'App\\Filament\\Pages')
            ->discoverWidgets(in: app_path('Filament/Widgets'), for: 'App\\Filament\\Widgets')
            ->pages([
                Pages\Dashboard::class,
            ])
            ->widgets([
                Widgets\AccountWidget::class,
                \App\Filament\Widgets\ReceiptStats::class,
            ]);
    }
}
