<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;

class Settlement extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'settlement_date',
        'settlement_mode',
        'settlement_amount',
        'proof_type',
        'image_upload',
        'remarks',
    ];

    public function user() {
        return $this->belongsTo(User::class);
    }

    protected static function booted()
    {
        static::creating(function ($settlement) {
            if (!$settlement->user_id) {
                $settlement->user_id = Auth::id();
            }
        });
    }
}
