<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Receipt extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'customer_id',
        'receipt_date',
        'invested_amount',
        'company_name',
        'receipt_customer_name',
        'relationship',
        'receipt_image',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    // Convert customer_id to uppercase before saving
    public function setCustomerIdAttribute($value)
    {
        $this->attributes['customer_id'] = strtoupper($value);
    }

    // Convert receipt_customer_name to uppercase before saving
    public function setReceiptCustomerNameAttribute($value)
    {
        $this->attributes['receipt_customer_name'] = strtoupper($value);
    }
}
