<?php

namespace App\Filament\Resources\Users\Tables;

use Filament\Actions\BulkActionGroup;
use Filament\Actions\DeleteBulkAction;
use Filament\Actions\EditAction;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;

class UsersTable
{
    public static function configure(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('name')
                    ->searchable(),
                TextColumn::make('father_name')
                    ->searchable(),
                TextColumn::make('sex')
                    ->searchable(),
                TextColumn::make('aadhar_no')
                    ->searchable(),
                TextColumn::make('pan_no')
                    ->searchable(),
                TextColumn::make('occupation')
                    ->searchable(),
                TextColumn::make('dob')
                    ->date()
                    ->sortable(),
                TextColumn::make('email')
                    ->label('Email address')
                    ->searchable(),
                TextColumn::make('mobile')
                    ->searchable(),
                TextColumn::make('whatsapp_no')
                    ->searchable(),
                TextColumn::make('member_level')
                    ->searchable(),
                TextColumn::make('primary_city')
                    ->searchable(),
                TextColumn::make('member_code')
                    ->searchable(),
                TextColumn::make('member_cadre')
                    ->searchable(),
                TextColumn::make('vg_group_code')
                    ->searchable(),
                TextColumn::make('vg_group_name')
                    ->searchable(),
                TextColumn::make('federation_code')
                    ->searchable(),
                TextColumn::make('federation_name')
                    ->searchable(),
                TextColumn::make('username')
                    ->searchable(),

                TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->recordActions([
                EditAction::make(),
            ])
            ->toolbarActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make(),
                ]),
            ]);
    }
}
