<?php

namespace App\Filament\Resources\Settlements\Tables;

use Filament\Actions\BulkActionGroup;
use Filament\Actions\DeleteBulkAction;
use Filament\Actions\EditAction;
use Filament\Tables\Columns\ImageColumn;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;
use NumberFormatter;

class SettlementsTable
{
    public static function configure(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('serial_no')
                    ->label('S.No')
                    ->alignCenter()
                    ->state(function ($rowLoop) {
                        return $rowLoop->iteration;
                    })
                    ->sortable(false)
                    ->searchable(false),
                TextColumn::make('settlement_date')->label('Settlement Date')->date()->date('d-m-Y'),
                TextColumn::make('settlement_mode')->searchable(),
                TextColumn::make('settlement_amount')
                    ->label('Settlement Amount')
                    ->alignRight()
                    ->formatStateUsing(function ($state) {
                        if ($state === null) return '-';
                        $formatter = new NumberFormatter('en_IN', NumberFormatter::DECIMAL);
                        return '₹ ' . $formatter->format($state);
                    }),
                TextColumn::make('proof_type')->searchable(),
                ImageColumn::make('image_upload'),
                TextColumn::make('remarks')->searchable(),
                TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->recordActions([
                EditAction::make(),
            ])
            ->toolbarActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make(),
                ]),
            ]);
    }
}
