<?php

namespace App\Filament\Resources\Receipts\Pages;

use App\Filament\Resources\Receipts\ReceiptResource;
use Filament\Resources\Pages\CreateRecord;
use Filament\Notifications\Notification;
use Filament\Facades\Filament;

class CreateReceipt extends CreateRecord
{
    protected static string $resource = ReceiptResource::class;
    protected static ?string $title = 'Add Receipt';

    protected function getRedirectUrl(): string
    {
        return $this->getResource()::getUrl('index');
    }

    protected function mutateFormDataBeforeCreate(array $data): array
    {
        // Automatically set the logged-in user ID
        $data['user_id'] = Filament::auth()->id();

        return $data;
    }

    protected function afterCreate(): void
    {
        // ✅ This will always show a toast — even after redirect
        Notification::make()
            ->title('Successfully added.')
            ->body('Your receipt has been saved successfully.')
            ->success()
            ->duration(4000)
            ->send();
        $this->form->fill();

        // Add a tiny delay before redirect so toast can render
        $this->dispatch('notify', [
            'type' => 'success',
            'title' => 'Successfully added.',
        ]);
    }


}
