<?php

namespace App\Filament\Pages;

use Filament\Pages\Page;
use Filament\Forms;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\ValidationException;
use BackedEnum;
use Filament\Notifications\Notification;
use App\Models\User;

class ChangePassword extends Page implements Forms\Contracts\HasForms
{
    use Forms\Concerns\InteractsWithForms;

    protected string $view = 'filament.pages.change-password';

    protected static string|BackedEnum|null $navigationIcon = 'heroicon-o-lock-closed';
    protected static ?string $navigationLabel = 'Change My Password';
    protected static ?string $title = 'Change My Password';
    protected static string|\UnitEnum|null $navigationGroup = 'Account';
    //protected static ?int $navigationSort = 999;

    public $current_password;
    public $password;
    public $password_confirmation;

    protected function getFormSchema(): array
    {
        return [
            Forms\Components\TextInput::make('current_password')
                ->label('Current Password')
                ->password()
                ->required(),

            Forms\Components\TextInput::make('password')
                ->label('New Password')
                ->password()
                ->required()
                ->minLength(6),

            Forms\Components\TextInput::make('password_confirmation')
                ->label('Confirm Password')
                ->password()
                ->required()
                ->same('password'),
        ];
    }

    public function submit(): void
    {
        $data = $this->form->getState();
        $user = Auth::user();

        if (!Hash::check($data['current_password'], $user->password)) {
            throw ValidationException::withMessages([
                'current_password' => 'Current password is incorrect.',
            ]);
        }

        User::where('id', Auth::id())->update([
            'password' => Hash::make($data['password']),
        ]);

        Notification::make()
            ->title('Password changed successfully!')
            ->success()
            ->icon('heroicon-o-check-circle')
            ->duration(5000)
            ->persistent()
            ->send();
        $this->form->fill(); // reset fields
    }
}
