<?php

namespace App\Filament\Pages\Auth;

use Filament\Auth\Pages\Login;

class UsernameLogin extends Login
{
    /**
     * Override the credentials logic to use username instead of email.
     */
    protected function getCredentialsFromFormData(array $data): array
    {
        return [
            'username' => $data['username'] ?? null,
            'password' => $data['password'] ?? null,
        ];
    }

    /**
     * Override the form fields to show Username instead of Email.
     */
    protected function getEmailFormComponent(): \Filament\Schemas\Components\Component
    {
        return \Filament\Forms\Components\TextInput::make('username')
            ->label('Username')
            ->required()
            ->autofocus()
            ->autocomplete('username')
            ->extraInputAttributes(['tabindex' => 1]);
    }

    // customer Id, receipt_date, invested_amount, company_name, Receipt_customer_name, Relationship, receipt_image
}
